<?php
/**
 * Ltranslate代理入口文件
 * 网方网站： http://ltranslate.cn/
 */

// 配置
const B_SERVER_URL ='http://engine.ltranslate.cn/site/html';
const CONNECT_TIMEOUT = 10;  // 连接超时时间（秒）
const TIMEOUT = 30;          // 总超时时间（秒）
const API_KEY = '32431242343214rwdfdsaffdsfdasfsda';  //你申请到的apikey
/**
 * 获取客户端请求头
 */
function getClientHeaders() {
    $headers = [];
    foreach ($_SERVER as $key => $value) {
        if (strpos($key, 'HTTP_') === 0) {
            $headerKey = str_replace('_', '-', strtolower(substr($key, 5)));
            $headers[$headerKey] = $value;
        }
    }
    return $headers;
}
function getScheme()
{
    //var_dump($_SERVER);
    
    $protoHeader = $_SERVER['HTTP_X_FORWARDED_PROTO'] ?? $_SERVER['REQUEST_SCHEME'] ?? ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http');
    $scheme = strtolower(explode(',', $protoHeader)[0]);
    return $scheme;
}
function getSourceUrl(){
    $hostHeader = $_SERVER['HTTP_HOST'] ?? '';
    $restPath = $_GET["path"] ?? $_SERVER["x-path"] ?? "";
    $originDomain = (defined('ORIGIN_DOMAIN') && ORIGIN_DOMAIN !== '') ? ORIGIN_DOMAIN : ($hostHeader !== '' ? preg_replace('/:\d+$/', '', $hostHeader) : 'localhost');
    $toUrl = getScheme() . '://' . $originDomain . '/' . $restPath;
    return $toUrl;
}
/**
 * 构建代理请求头
 */
function buildProxyHeaders($clientHeaders) {
    
    $existingXff = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? '';
    $forwarded = $existingXff ? ($existingXff . ', ' . $remoteAddr) : $remoteAddr;
    $lang = $_GET["target-lang"] ?? $_SERVER["x-target-lang"] ?? ""; 
    $proxyHeaders = [
        'Host' => 'engine.ltranslate.cn', // 修改为实际目标域名
        'User-Agent' => $clientHeaders['user-agent'] ?? 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept' => $clientHeaders['accept'] ?? 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language' => $clientHeaders['accept-language'] ?? 'zh-CN,zh;q=0.9,en;q=0.8',
        'Accept-Encoding' => 'gzip, deflate, br', // 允许压缩，但cURL会自动处理
        'Connection' => 'keep-alive',
        'X-Forwarded-For' => $forwarded,
        'Upgrade-Insecure-Requests' => '1',
        'Cache-Control' => 'no-cache',
        'Pragma' => 'no-cache',
        'target-lang' => $lang,
        'api-key' => API_KEY,
        'source-lang' => 'zh-cn',
        'url' => getSourceUrl(),
    ];
    
    // 添加 Referer（如果存在）
    if (isset($clientHeaders['referer'])) {
        $proxyHeaders['Referer'] = $clientHeaders['referer'];
    } else {
        $proxyHeaders['Referer'] = 'https://' . ($_SERVER['HTTP_HOST'] ?? 'test-proxy-php.52bugu.com') . '/';
    }
    
    // 传递Cookie（关键：保持session状态）
    if (isset($clientHeaders['cookie'])) {
        $proxyHeaders['Cookie'] = $clientHeaders['cookie'];
    }
    
    // 传递X-Forwarded头
    $remoteAddr = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    $existingXff = $clientHeaders['x-forwarded-for'] ?? '';
    $xff = $existingXff ? ($existingXff . ', ' . $remoteAddr) : $remoteAddr;
    
    $proxyHeaders['X-Real-IP'] = $remoteAddr;
    $proxyHeaders['X-Forwarded-For'] = $xff;
    $proxyHeaders['X-Forwarded-Host'] = $_SERVER['HTTP_HOST'] ?? '';
    $proxyHeaders['X-Forwarded-Proto'] = isset($_SERVER['HTTPS']) ? 'https' : 'http';
    
    // 传递请求路径和参数
    $requestUri = $_SERVER['REQUEST_URI'] ?? '/';
    
    // 解析语言路径
    $targetLang = 'ja'; // 默认语言
    $path = 'admin/';   // 默认路径
    
    if (preg_match('#^/([a-z]{2})/(admin/.*)$#', $requestUri, $matches)) {
        $targetLang = $matches[1];
        $path = $matches[2];
    }
    
    // 重建完整的原始路径
    $originalPath = '/' . trim($targetLang, '/') . '/' . trim($path, '/');
    if (substr($originalPath, -1) !== '/') {
        $originalPath .= '/';
    }
    
    // 关键：传递完整的路径信息给A服务器
    $proxyHeaders['X-Original-URI'] = $originalPath;
    $proxyHeaders['X-Target-Lang'] = $targetLang;
    $proxyHeaders['X-Original-Path'] = $path;
    $proxyHeaders['X-Original-Request-URI'] = $originalPath;
    
    // 关键：确保表单提交路径正确
    $proxyHeaders['X-Form-Action-Path'] = $originalPath;
    
    // 传递完整的请求URI，包括查询参数
    $queryString = $_SERVER['QUERY_STRING'] ?? '';
    if ($queryString) {
        $proxyHeaders['X-Original-URI'] .= '?' . $queryString;
        $proxyHeaders['X-Original-Request-URI'] .= '?' . $queryString;
    }
    
    // 如果是POST请求，传递POST数据
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $proxyHeaders['Content-Type'] = $_SERVER['CONTENT_TYPE'] ?? 'application/x-www-form-urlencoded';
    }
    
    return $proxyHeaders;
}

/**
 * 测试B服务器连接
 */
function testBServerConnection() {
    $testUrl = B_SERVER_URL;
    $ch = curl_init();
    
    curl_setopt_array($ch, [
        CURLOPT_URL => $testUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_NOBODY => true,  // HEAD请求，不下载内容
        CURLOPT_TIMEOUT => 10,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_FOLLOWLOCATION => true,  // 跟随重定向
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Connection Test)',
        CURLOPT_ENCODING => '', // 自动处理所有支持的编码
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);
    
    return [
        'success' => $httpCode === 200,
        'http_code' => $httpCode,
        'error' => $error,
        'info' => $info,
        'url' => $testUrl,
        'response' => $response
    ];
}

/**
 * 发送代理请求到B服务器
 */
function sendProxyToBServer($url, $headers) {
    $ch = curl_init();
    
    // 构建cURL头数组
    $curlHeaders = [];
    foreach ($headers as $key => $value) {
        $curlHeaders[] = $key . ': ' . $value;
    }
    
    
     // 设置cURL选项
    $curlOptions = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false, // 忽略SSL证书验证
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_TIMEOUT => TIMEOUT,
        CURLOPT_CONNECTTIMEOUT => CONNECT_TIMEOUT,
        CURLOPT_HTTPHEADER => $curlHeaders,
        CURLOPT_HEADER => true,         // 包含响应头
        CURLOPT_USERAGENT => $headers['User-Agent'] ?? 'Proxy Client',
        CURLOPT_FAILONERROR => false,   // 不在HTTP错误时立即返回错误，我们需要获取详细信息
        CURLOPT_ENCODING => '',         // 自动处理所有支持的编码（gzip, deflate等）
    ];
    
    // 如果是POST请求，传递POST数据
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $curlOptions[CURLOPT_POST] = true;
        $curlOptions[CURLOPT_POSTFIELDS] = file_get_contents('php://input');
    }
    
    curl_setopt_array($ch, $curlOptions);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    $info = curl_getinfo($ch);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $responseBody = substr($response, $headerSize);
    // 如果有错误，抛出包含详细信息的异常
    if ($error) {
        throw new Exception('cURL错误: ' . $error . '. 详细信息: ' . print_r($info, true));
    }
    curl_close($ch);
    return [
        'http_code' => $httpCode,
        'headers' => $responseHeaders,
        'body' => $responseBody,
        'response' => $response,
        'info' => $info
    ];
}

/**
 * 处理响应头
 */
function processResponseHeaders($responseHeaders) {
    $headers = [];
    $headerLines = explode("\r\n", $responseHeaders);
    
    foreach ($headerLines as $line) {
        if (strpos($line, ':') !== false) {
            list($key, $value) = explode(':', $line, 2);
            $headers[trim($key)] = trim($value);
        }
    }
    
    return $headers;
}

/**
 * 设置响应头
 */
function setResponseHeaders($headers) {
    // 设置Cookie（关键：保持session同步）
    if (isset($headers['Set-Cookie'])) {
        // 修改这里，允许多个Set-Cookie头
        if (is_array($headers['Set-Cookie'])) {
            foreach ($headers['Set-Cookie'] as $cookie) {
                header('Set-Cookie: ' . $cookie, false);
            }
        } else {
            header('Set-Cookie: ' . $headers['Set-Cookie'], false);
        }
    }
    
    // 设置其他重要头
    //$importantHeaders = ['Content-Type', 'Location', 'Cache-Control', 'Pragma', 'Expires'];
    $importantHeaders = ['Content-Type', 'Cache-Control', 'Pragma', 'Expires'];
    foreach ($importantHeaders as $header) {
        if (isset($headers[$header])) {
            // 特别处理Content-Encoding，让浏览器正确解压内容
            if ($header !== 'Content-Encoding') {
                header($header . ': ' . $headers[$header], false);
            }
        }
    }
    
    // 设置Content-Type默认值
    if (!isset($headers['Content-Type'])) {
        header('Content-Type: text/html; charset=utf-8', false);
    }
}

/**
 * 显示调试信息
 */
function showDebugInfo($clientHeaders, $proxyHeaders, $response) {
    echo '<div style="position: fixed; top: 10px; right: 10px; background: rgba(0,0,0,0.8); color: white; padding: 15px; border-radius: 5px; font-size: 12px; max-width: 500px; z-index: 1000;">';
    echo '<h4 style="margin: 0 0 10px 0;">go.php - 代理调试信息</h4>';
    
    echo '<div style="margin-bottom: 10px;">';
    echo '<strong>目标B服务器：</strong>' . B_SERVER_URL . '<br>';
    echo '<strong>HTTP状态码：</strong>' . $response['http_code'] . '<br>';
    echo '<strong>请求方法：</strong>' . $_SERVER['REQUEST_METHOD'] . '<br>';
    echo '<strong>客户端IP：</strong>' . ($_SERVER['REMOTE_ADDR'] ?? '未知') . '<br>';
    echo '</div>';
    
    echo '<div style="margin-bottom: 10px;">';
    echo '<strong>传递的Cookie：</strong><br>';
    echo htmlspecialchars($proxyHeaders['Cookie'] ?? '无') . '<br>';
    echo '</div>';
    
    echo '<div style="margin-bottom: 10px;">';
    echo '<strong>请求路径：</strong> ' . ($_SERVER['REQUEST_URI'] ?? '/') . '<br>';
    echo '</div>';
    
    echo '<button onclick="this.parentNode.style.display=\"none\";" style="background: #dc3545; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer;">关闭</button>';
    echo '</div>';
}

// 主逻辑
try {
    // 获取客户端请求头
    $clientHeaders = getClientHeaders();
    // 构建代理请求头
    $proxyHeaders = buildProxyHeaders($clientHeaders);
    
    // 调试：显示请求头信息
    if (isset($_GET['debug'])) {
        echo '<div style="position: fixed; top: 10px; left: 10px; background: rgba(255,0,0,0.8); color: white; padding: 15px; border-radius: 5px; font-size: 12px; max-width: 500px; z-index: 1000;">';
        echo '<h4>调试信息 - 请求头</h4>';
        echo '<pre>' . htmlspecialchars(print_r($proxyHeaders, true)) . '</pre>';
        echo '</div>';
    }
    
    $response = sendProxyToBServer(B_SERVER_URL, $proxyHeaders);
    // 处理响应头
    $responseHeaders = processResponseHeaders($response['headers']);
    
    // 设置响应头
    setResponseHeaders($responseHeaders);
    //
    // 如果是重定向，直接跳到未翻译的页面
    if ($response['http_code'] >= 300 && $response['http_code'] < 400 && isset($responseHeaders['Location'])) {
        header('Location: ' . getSourceUrl());
        exit;
    }
    if ($response['http_code'] == 405 || $response['http_code'] == 406) {
        //打印提示 405=余额不足；406=限流或网关限制访问
        
    }
    // 输出响应内容
    echo $response['body'];
    
    // 显示调试信息（仅在调试模式下）
    if (isset($_GET['debug'])) {
        showDebugInfo($clientHeaders, $proxyHeaders, $response);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo '<!DOCTYPE html>
    <html>
    <head>
        <title>代理错误 - go.php</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 50px; background: #f8d7da; color: #721c24; }
            .error-container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; }
        </style>
    </head>
    <body>
        <div class="error-container">
            <h2>代理服务器错误 (go.php)</h2>
            <p><strong>错误信息：</strong>' . htmlspecialchars($e->getMessage()) . '</p>
            <p><strong>请检查：</strong></p>
            <ul>
                <li>B服务器 ' . B_SERVER_URL . ' 是否可访问</li>
                <li>网络连接是否正常</li>
                <li>B服务器上的proxy.php文件是否存在</li>
                <li>防火墙设置是否正确</li>
            </ul>
            <div style="margin-top: 20px; padding: 15px; background: #f8f9fa; border-radius: 4px;">
                <h4>调试信息：</h4>
                <p><strong>当前文件：</strong>' . __FILE__ . '</p>
                <p><strong>请求URI：</strong>' . ($_SERVER['REQUEST_URI'] ?? '/') . '</p>
            </div>
        </div>
    </body>
    </html>';
}
?>